/*
 * packet.h -- GPS protocol packet in/out function prototypes
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/packet.h,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 19:25 Aug  4 2000 kivinen
 *	  Last Modification : 20:28 Aug  4 2000 kivinen
 *	  Last check in     : $Date: 2000/08/05 00:44:09 $
 *	  Revision number   : $Revision: 1.1 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.20
 *	  Edit time	    : 4 min
 *
 *	  Description       : GPS protocol packet in/out function prototypes
 *
 *	  $Log: packet.h,v $
 *	  Revision 1.1  2000/08/05 00:44:09  kivinen
 *	  	Created.
 *
 *	  $EndLog$
 */

#ifndef TGPS_PACKET_H
#define TGPS_PACKET_H

#include "tgps.h"

/* Process waypoint data packet */
int tgps_wpt_data_in(Tgps conn, TgpsPacket packet, TgpsWaypoint w);

/* Process proximity waypoint data packet */
int tgps_prx_wpt_data_in(Tgps conn, TgpsPacket packet, TgpsWaypoint w);

/* Send waypoint data packet */
TgpsPacket tgps_wpt_data_out(Tgps conn, TgpsWaypoint w);

/* Process route header packet */
int tgps_rte_hdr_data_in(Tgps conn, TgpsPacket packet, TgpsRouteHeader r);

/* Send route header packet */
TgpsPacket tgps_rte_hdr_data_out(Tgps conn, TgpsRouteHeader r);

/* Process route link packet */
int tgps_rte_lnk_data_in(Tgps conn, TgpsPacket packet, TgpsRouteLnk r);

/* Send route link packet */
TgpsPacket tgps_rte_lnk_data_out(Tgps conn, TgpsRouteLnk r);

/* Process track point packet */
int tgps_track_data_in(Tgps conn, TgpsPacket packet, TgpsTrack t);

/* Send track log packet */
TgpsPacket tgps_track_data_out(Tgps conn, TgpsTrack t);

/* Process track header packet */
int tgps_track_hdr_data_in(Tgps conn, TgpsPacket packet, TgpsTrackHeader t);

/* Send track log packet */
TgpsPacket tgps_track_hdr_data_out(Tgps conn, TgpsTrackHeader t);

/* Process almanac packet */
int tgps_almanac_data_in(Tgps conn, TgpsPacket packet, TgpsAlmanac a);

/* Send almanac data packet */
TgpsPacket tgps_almanac_data_out(Tgps conn, TgpsAlmanac a);

/* Process time packet */
int tgps_time_data_in(Tgps conn, TgpsPacket packet, TgpsTime t);

/* Send time packet */
TgpsPacket tgps_time_data_out(Tgps conn, TgpsTime t);

/* Process position packet */
int tgps_position_data_in(Tgps conn, TgpsPacket packet, TgpsPosition p);

/* Send position packet */
TgpsPacket tgps_position_data_out(Tgps conn, TgpsPosition pos);

/* Process pvt packet */
int tgps_pvt_data_in(Tgps conn, TgpsPacket packet, TgpsPvt p);

/* Send pvt packet */
TgpsPacket tgps_pvt_data_out(Tgps conn, TgpsPvt pvt);

#endif /* TGPS_PACKET_H */

