/*
 * map.c -- Coordinate conversion routines
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/map.c,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 17:31 Oct  2 2000 kivinen
 *	  Last Modification : 22:45 Apr 13 2002 kivinen
 *	  Last check in     : $Date: 2003/08/18 20:10:50 $
 *	  Revision number   : $Revision: 1.2 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.48
 *	  Edit time	    : 38 min
 *
 *	  Description       : Coordinate conversion routines
 *
 *	  $Log: map.c,v $
 *	  Revision 1.2  2003/08/18 20:10:50  kivinen
 *	  	Added support for GPS V. Fixed packet size and actual size
 *	  	comparisions.
 *
 *	  Revision 1.1  2000/10/02 15:44:01  kivinen
 *	  	Created.
 *
 *	  $EndLog$
 */

#include "tgps.h"
#include "map.h"

void tgps_polar_to_xyz(double lat, double lon,
		       double *x, double *y, double *z)
{
  double tmp;
  
  tmp = cos(lat);
  (*x) = sin(lon) * tmp;
  (*y) = cos(lon) * tmp;
  (*z) = sin(lat);
}

double tgps_point_distance(double lat1, double lon1,
			   double lat2, double lon2)
{
  double x1, y1, z1;
  double x2, y2, z2;
  double x, y, z;
  double dist;

  tgps_polar_to_xyz(lat1, lon1, &x1, &y1, &z1);
  tgps_polar_to_xyz(lat2, lon2, &x2, &y2, &z2);

  x = x1 * x2;
  y = y1 * y2;
  z = z1 * z2;

  dist = acos(x + y + z);
  dist = dist * WGS84_EARTH_RADIUS(lat2 - lat1);
  return dist;
}

#if 0
int main(int argc, char **argv)
{
  printf("%f\n", tgps_point_distance(atof(argv[1]), atof(argv[2]),
				     atof(argv[3]), atof(argv[4])));
  exit(0);
}
#endif
