/*
 * ieee-double.c -- IEEE double routines
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/ieee-double.h,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 17:47 Apr 20 2000 kivinen
 *	  Last Modification : 23:00 Apr 20 2000 kivinen
 *	  Last check in     : $Date: 2000/04/29 16:40:18 $
 *	  Revision number   : $Revision: 1.1 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.26
 *	  Edit time	    : 4 min
 *
 *	  Description       : IEEE double routines
 *
 *	  $Log: ieee-double.h,v $
 *	  Revision 1.1  2000/04/29 16:40:18  kivinen
 *	  	Created.
 *
 *	  $EndLog$
 */

#ifndef IEEE_DOUBLE_H
#define IEEE_DOUBLE_H

/* Lenght of IEEE doubles and floats */
#define IEEE_DOUBLE_LEN	8
#define IEEE_FLOAT_LEN	4

/* Convert IEEE double format number from buffer to machine representation */
double tgps_buf2d(unsigned char *buf);

/* Convert IEEE double format number from buffer to machine representation, LSB
   first. */
double tgps_buf2d_lsb(unsigned char *buf);

/* Convert machine double to IEEE double and store it to buffer. Buffer must be
   at least 8 characters long. */
void tgps_d2buf(unsigned char *buf, double d);

/* Convert machine double to IEEE double and store it to buffer. Buffer must be
   at least 8 characters long. LSB first. */
void tgps_d2buf_lsb(unsigned char *buf, double d);

/* Convert IEEE float format number from buffer to machine representation. */
float tgps_buf2f(unsigned char *buf);

/* Convert IEEE float format number from buffer to machine representation, LSB
   first.  */
float tgps_buf2f_lsb(unsigned char *buf);

/* Convert machine float to IEEE double and store it to buffer. Buffer must be
   at least 4 characters long. */
void tgps_f2buf(unsigned char *buf, float f);

/* Convert machine float to IEEE double and store it to buffer. Buffer must be
   at least 4 characters long. LSB first. */
void tgps_f2buf_lsb(unsigned char *buf, float f);

#endif /* IEEE_DOUBLE_H */
