/*
 * garmin.h -- Garmin GPS protocol definitions.
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/garmin.h,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 15:17 Apr  7 2000 kivinen
 *	  Last Modification : 08:56 Jul 23 2000 kivinen
 *	  Last check in     : $Date: 2000/07/23 20:22:51 $
 *	  Revision number   : $Revision: 1.3 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.101
 *	  Edit time	    : 47 min
 *
 *	  Description       : Garmin GPS protocol definitions
 *
 *	  $Log: garmin.h,v $
 *	  Revision 1.3  2000/07/23 20:22:51  kivinen
 *	  	Added fix string conversion.
 *
 *	  Revision 1.2  2000/04/30 01:03:40  kivinen
 *	  	Updated to rev 03 document.
 *
 *	  Revision 1.1  2000/04/29 16:40:09  kivinen
 *	  	Created.
 *
 *	  $EndLog$
 */

#ifndef GARMIN_H
#define GARMIN_H

#define TGPS_ETX	3
#define TGPS_DLE	16

/* Link layer protocol id numbers for L000 protocol */
typedef enum {
  TGPS_PID_L000_ACK_BYTE = 6,
  TGPS_PID_L000_NAK_BYTE = 21,
  TGPS_PID_L000_PROTOCOL_ARRAY = 253,
  TGPS_PID_L000_PRODUCT_RQST = 254,
  TGPS_PID_L000_PRODUCT_DATA = 255
} TgpsPidL000;

/* Link layer protocol id numbers for L001 protocol, all products also support
   L000 set. */
typedef enum {
  TGPS_PID_L001_COMMAND_DATA = 10,
  TGPS_PID_L001_XFER_CMPLT = 12,
  TGPS_PID_L001_DATE_TIME_DATA = 14,
  TGPS_PID_L001_POSITION_DATA = 17,
  TGPS_PID_L001_PRX_WPT_DATA = 19,
  TGPS_PID_L001_RECORDS = 27,
  TGPS_PID_L001_RTE_HDR = 29,
  TGPS_PID_L001_RTE_WPT_DATA = 30,
  TGPS_PID_L001_ALMANAC_DATA = 31,
  TGPS_PID_L001_TRK_DATA = 34,
  TGPS_PID_L001_WPT_DATA = 35,
  TGPS_PID_L001_PVT_DATA = 51,
  TGPS_PID_L001_RTE_LINK_DATA = 98,
  TGPS_PID_L001_TRK_HDR = 99
} TgpsPidL001;

/* Link layer protocol id numbers for L002 protocol, all products also support
   L000 set. */
typedef enum {
  TGPS_PID_L002_ALMANAC_DATA = 4,
  TGPS_PID_L002_COMMAND_DATA = 11,
  TGPS_PID_L002_XFER_CMPLT = 12,
  TGPS_PID_L002_DATE_TIME_DATA = 20,
  TGPS_PID_L002_POSITION_DATA = 24,
  TGPS_PID_L002_RECORDS = 35,
  TGPS_PID_L002_RTE_HDR = 37,
  TGPS_PID_L002_RTE_WPT_DATA = 39,
  TGPS_PID_L002_WPT_DATA = 43
} TgpsPidL002;

#define TGPS_PID_COMMAND_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_COMMAND_DATA : \
   (tgps_is_supported((conn), 'L', 2) ? \
     TGPS_PID_L002_COMMAND_DATA : -1))
#define TGPS_PID_XFER_CMPL(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_XFER_CMPLT : \
   (tgps_is_supported((conn), 'L', 2) ? \
     TGPS_PID_L002_XFER_CMPLT : -1))
#define TGPS_PID_DATE_TIME_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_DATE_TIME_DATA : \
   (tgps_is_supported((conn), 'L', 2) ? \
     TGPS_PID_L002_DATE_TIME_DATA : -1))
#define TGPS_PID_POSITION_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_POSITION_DATA : \
   (tgps_is_supported((conn), 'L', 2) ? \
     TGPS_PID_L002_POSITION_DATA : -1))
#define TGPS_PID_PRX_WPT_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_PRX_WPT_DATA : -1)
#define TGPS_PID_RECORDS(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_RECORDS : \
   (tgps_is_supported((conn), 'L', 2) ? \
     TGPS_PID_L002_RECORDS : -1))
#define TGPS_PID_RTE_HDR(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_RTE_HDR : \
   (tgps_is_supported((conn), 'L', 2) ? \
     TGPS_PID_L002_RTE_HDR : -1))
#define TGPS_PID_RTE_WPT_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_RTE_WPT_DATA : \
   (tgps_is_supported((conn), 'L', 2) ? \
     TGPS_PID_L002_RTE_WPT_DATA : -1))
#define TGPS_PID_ALMANAC_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_ALMANAC_DATA : \
   (tgps_is_supported((conn), 'L', 2) ? \
     TGPS_PID_L002_ALMANAC_DATA : -1))
#define TGPS_PID_TRK_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_TRK_DATA : -1)
#define TGPS_PID_WPT_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_WPT_DATA : \
   (tgps_is_supported((conn), 'L', 2) ? \
     TGPS_PID_L002_WPT_DATA : -1))
#define TGPS_PID_PVT_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_PVT_DATA : -1)
#define TGPS_PID_RTE_LINK_DATA(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_RTE_LINK_DATA : -1)
#define TGPS_PID_TRK_HDR(conn) \
  (tgps_is_supported((conn), 'L', 1) ? \
   TGPS_PID_L001_TRK_HDR : -1)

/* Application layer protocol id numbers for A010 protocol. */
typedef enum {
  TGPS_CMND_A010_ABORT_TRANSFER = 0, /* abort current transfer */
  TGPS_CMND_A010_TRANSFER_ALM = 1, /* transfer almanac */
  TGPS_CMND_A010_TRANSFER_POSN = 2, /* transfer position */
  TGPS_CMND_A010_TRANSFER_PRX = 3, /* transfer proximity waypoints */
  TGPS_CMND_A010_TRANSFER_RTE = 4, /* transfer routes */
  TGPS_CMND_A010_TRANSFER_TIME = 5, /* transfer time */
  TGPS_CMND_A010_TRANSFER_TRK = 6, /* transfer track log */
  TGPS_CMND_A010_TRANSFER_WPT = 7, /* transfer waypoints */
  TGPS_CMND_A010_TURN_OFF_PWR = 8, /* turn off power */
  TGPS_CMND_A010_START_PVT_DATA = 49, /* start transmitting PVT data */
  TGPS_CMND_A010_STOP_PVT_DATA = 50 /* stop transmitting PVT data */
} TgpsCmndA010;

/* Application layer protocol id numbers for A011 protocol. */
typedef enum {
  TGPS_CMND_A011_ABORT_TRANSFER = 0, /* abort current transfer */
  TGPS_CMND_A011_TRANSFER_ALM = 4, /* transfer almanac */
  TGPS_CMND_A011_TRANSFER_RTE = 8, /* transfer routes */
  TGPS_CMND_A011_TRANSFER_TIME = 20, /* transfer time */
  TGPS_CMND_A011_TRANSFER_WPT = 21, /* transfer waypoints */
  TGPS_CMND_A011_TURN_OFF_PWR = 26 /* turn off power */
} TgpsCmndA011;

#define TGPS_CMND_ABORT_TRANSFER(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_ABORT_TRANSFER : \
   (tgps_is_supported((conn), 'A', 11) ? \
     TGPS_CMND_A011_ABORT_TRANSFER : -1))
#define TGPS_CMND_TRANSFER_ALM(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_TRANSFER_ALM : \
   (tgps_is_supported((conn), 'A', 11) ? \
     TGPS_CMND_A011_TRANSFER_ALM : -1))
#define TGPS_CMND_TRANSFER_POSN(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_TRANSFER_POSN : -1)
#define TGPS_CMND_TRANSFER_PRX(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_TRANSFER_PRX : -1)
#define TGPS_CMND_TRANSFER_RTE(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_TRANSFER_RTE : \
   (tgps_is_supported((conn), 'A', 11) ? \
     TGPS_CMND_A011_TRANSFER_RTE : -1))
#define TGPS_CMND_TRANSFER_TIME(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_TRANSFER_TIME : \
   (tgps_is_supported((conn), 'A', 11) ? \
     TGPS_CMND_A011_TRANSFER_TIME : -1))
#define TGPS_CMND_TRANSFER_TRK(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_TRANSFER_TRK : -1)
#define TGPS_CMND_TRANSFER_WPT(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_TRANSFER_WPT : \
   (tgps_is_supported((conn), 'A', 11) ? \
     TGPS_CMND_A011_TRANSFER_WPT : -1))
#define TGPS_CMND_TURN_OFF_PWR(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_TURN_OFF_PWR : \
   (tgps_is_supported((conn), 'A', 11) ? \
     TGPS_CMND_A011_TURN_OFF_PWR : -1))
#define TGPS_CMND_START_PVT_DATA(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_START_PVT_DATA : -1)
#define TGPS_CMND_STOP_PVT_DATA(conn) \
  (tgps_is_supported((conn), 'A', 10) ? \
   TGPS_CMND_A010_STOP_PVT_DATA : -1)

/* Find Garmin product name based on the product id */
const char *tgps_find_garmin_name(int product_id);

/* Find physical protocol ids. */
void tgps_find_phys_protocol_ids(int product_id, int software_version,
				 int **table, int *cnt);

/* Find link protocol ids. */
void tgps_find_link_protocol_ids(int product_id, int software_version,
				 int **table, int *cnt);

/* Find application protocol ids. */
void tgps_find_appl_protocol_ids(int product_id, int software_version,
				 int **table, int *cnt);

/* Find data protocol ids. */
void tgps_find_data_protocol_ids(int product_id, int software_version,
				 int **table, int *cnt);

typedef enum {
  TGPS_GARMIN_SYMBOLS_FULL = 0,
  TGPS_GARMIN_SYMBOLS_16 = 1
} TgpsGarminSymbolType;

/* Convert symbol number to string */
const char *tgps_symbol_to_string(TgpsGarminSymbolType type,
				  int symbol);

/* Convert symbol string to number */
int tgps_string_to_symbol(TgpsGarminSymbolType type,
			  const char *name);

/* Convert color number to string */
const char *tgps_color_to_string(int color);

/* Convert color string to number */
int tgps_string_to_color(const char *name);

/* Convert fix number to string */
const char *tgps_fix_to_string(int fix);

/* Convert fix string to number */
int tgps_string_to_fix(const char *name);

#endif /* GARMIN_H */
