/*
 * data.h -- Data type clear, default, and free routines
 *
 * Copyright (c) 2000 Tero Kivinen <kivinen@iki.fi>
 */
/*
 *        Program: tgps
 *	  $Source: /u/kivinen/gps/tgps/RCS/data.h,v $
 *	  Author : $Author: kivinen $
 *
 *	  Creation          : 19:13 Aug  4 2000 kivinen
 *	  Last Modification : 20:43 Aug  4 2000 kivinen
 *	  Last check in     : $Date: 2000/08/05 00:43:23 $
 *	  Revision number   : $Revision: 1.1 $
 *	  State             : $State: Exp $
 *	  Version	    : 1.4
 *	  Edit time	    : 2 min
 *
 *	  Description       : Data type clear, default, and free routines
 *
 *	  $Log: data.h,v $
 *	  Revision 1.1  2000/08/05 00:43:23  kivinen
 *	  	Created.
 *
 *	  $EndLog$
 */

#ifndef TGPS_DATA_H
#define TGPS_DATA_H

#include "tgps.h"

/* Clear waypoint structure */
void tgps_clear_waypoint(TgpsWaypoint w);

/* Set values to defaults in waypoint structure */
void tgps_defaults_waypoint(TgpsWaypoint w);

/* Free waypoint structure */
void tgps_free_waypoint(TgpsWaypoint w);

/* Clear route header structure */
void tgps_clear_route_header(TgpsRouteHeader r);

/* Set values to defaults in route header structure */
void tgps_defaults_route_header(TgpsRouteHeader r);

/* Free route header structure */
void tgps_free_route_header(TgpsRouteHeader r);

/* Clear route link structure */
void tgps_clear_route_link(TgpsRouteLnk r);

/* Set values to defaults in route link structure */
void tgps_defaults_route_link(TgpsRouteLnk r);

/* Free route link structure */
void tgps_free_route_link(TgpsRouteLnk r);

/* Clear almanac header structure */
void tgps_clear_almanac(TgpsAlmanac a);

/* Free route header structure */
void tgps_free_almanac(TgpsAlmanac a);

/* Clear track structure */
void tgps_clear_track(TgpsTrack t);

/* Set values to defaults in track structure */
void tgps_defaults_track(TgpsTrack t);

/* Clear track header structure */
void tgps_clear_track_header(TgpsTrackHeader t);

/* Set valus to defaults in track header structure */
void tgps_defaults_track_header(TgpsTrackHeader t);

/* Free track header structure */
void tgps_free_track_header(TgpsTrackHeader t);

#endif /* TGPS_DATA_H */

